﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MyStoreIntegration.MyStore;

namespace MyStoreIntegration.Helpers
{
    class LongRunProcessor
    {
        public static ProcessResult GetProcessResult(DefaultSoapClient soapClient, InvokeResult invokeResult)
        {
            while (true)
            {
                var processResult = soapClient.GetProcessStatus(invokeResult);
                switch (processResult.Status)
                {
                    case ProcessStatus.NotExists:
                    case ProcessStatus.Aborted:
                        throw new SystemException("Process status: " + processResult.Status + "; Error: " + processResult.Message);
                    case ProcessStatus.Completed:
                        //Go to normal processing
                        return processResult; 
                    case ProcessStatus.InProcess:
                        //Insert the needed waiting time here
                        if (processResult.Seconds > 30) 
                            throw new TimeoutException(); 
                        continue;
                    default:
                        throw new InvalidOperationException();
                }
            }

        }
    }
}
