﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MyStoreIntegration.MyStore;
using System.IO;

namespace MyStoreIntegration.Integration
{
    class CustomerManager
    {
        //Creating a customer record
        public static void CreateCustomer(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Creating a customer record...");

            // Customer data
            string customerID = "JOHNGOOD"; //Specify any customer ID that does not exist in the system
            string customerName = "John Good";
            string customerMainContactEmail = "demo@gmail.com";
            string customerMainContactAddressLine1 = "4030 Lake Washington Blvd NE";
            string customerMainContactAddressLine2 = "Suite 100";
            string customerMainContactCity = "Kirkland";
            string customerMainContactState = "WA";
            string customerMainContactPostalCode = "98033";

            //Specify the values of a new customer record
            Customer customerToBeCreated = new Customer
            {
                CustomerID = new StringValue { Value = customerID },
                CustomerName = new StringValue { Value = customerName },
                MainContact = new Contact
                {
                    Email = new StringValue { Value = customerMainContactEmail },
                    Address = new Address
                    {
                        AddressLine1 = new StringValue { Value = customerMainContactAddressLine1 },
                        AddressLine2 = new StringValue { Value = customerMainContactAddressLine2 },
                        City = new StringValue { Value = customerMainContactCity },
                        State = new StringValue { Value = customerMainContactState },
                        PostalCode = new StringValue { Value = customerMainContactPostalCode }
                    }
                },
            };
            //Create a customer record with the specified values
            Customer newCustomer = (Customer)soapClient.Put(customerToBeCreated);

            //Display the ID and customer class of the created record
            Console.WriteLine("Customer ID: " + newCustomer.CustomerID.Value);
            Console.WriteLine("Customer class: " + newCustomer.CustomerClass.Value);
            Console.WriteLine();
            Console.WriteLine("Press any key to continue");
            Console.ReadLine();
        }

        //Updating a customer record
        public static void UpdateCustomer(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Updating a customer record...");

            //Customer data
            string customerMainContactEmail = "info@jevy-comp.con"; //Specify the email address of a customer that exists in the system
            string customerClass = "INTL"; //Specify one of the customer classes that are configured in the system

            //Select the needed customer record and 
            //specify the values that should be updated
            Customer customerToBeUpdated = new Customer
            {
                MainContact = new Contact
                {
                    //Search for the customer record by email address
                    Email = new StringSearch { Value = customerMainContactEmail },
                },
                CustomerClass = new StringValue { Value = customerClass },
            };

            //Update the customer record with the specified values
            Customer updCustomer = (Customer)soapClient.Put(customerToBeUpdated);

            //Display the ID and customer class of the updated record
            Console.WriteLine("Customer ID: " + updCustomer.CustomerID.Value);
            Console.WriteLine("Customer class: " + updCustomer.CustomerClass.Value);
            Console.WriteLine();
            Console.WriteLine("Press any key to continue");
            Console.ReadLine();
        }

        //Adding a customer billing contact
        public static void AddCustomerBillingContact(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Adding a customer billing contact...");

            //Customer data
            string customerID = "C000000003"; //Specify a customer ID that exists in the system
            string contactTitle = "Mr.";
            string contactFirstName = "Jack";
            string contactLastName = "Green";
            string contactEmail = "green@jevy-comp.con";

            //Select the customer record and 
            //specify the customer billing contact
            Customer customerToBeUpdated = new Customer
            {
                //Search for a customer record by customer ID
                CustomerID = new StringSearch { Value = customerID },
                //Specify the values of the customer billing contact
                BillingContactSameAsMain = new BooleanValue { Value = false },
                BillingContact = new Contact
                {
                    Email = new StringValue { Value = contactEmail },
                    Position = new StringValue { Value = contactTitle + " " + contactFirstName + " " + contactLastName }
                }
            };

            //Add the contact to the customer record
            Customer customerContact = (Customer)soapClient.Put(customerToBeUpdated);

            //Display the customer ID and billing contact name and email address
            Console.WriteLine("Customer ID: " + customerContact.CustomerID.Value);
            Console.WriteLine("Billing contact name: " + customerContact.BillingContact.Position.Value);
            Console.WriteLine("Billing contact email: " + customerContact.BillingContact.Email.Value);
            Console.WriteLine();
            Console.WriteLine("Press any key to continue");
            Console.ReadLine();
        }

        //Retrieving customer data by Customer ID 
        public static void ExportCustomer(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Retrieving customer data by customer ID...");

            //Customer data
            string customerID = "C000000003"; //Specify a customer ID that exists in the system

            //Obtain the customer record with the specified customer ID
            Customer customer = new Customer
            {
                CustomerID = new StringSearch { Value = customerID },
            };
            Customer customerData = (Customer)soapClient.Get(customer);

            //Save a customer record to a CSV file
            using (StreamWriter file = new StreamWriter(string.Format(@"Customer_{0}.csv", customerID)))
            {
                //Add headers to the file
                file.WriteLine("CustomerID;CustomerName;CustomerClass;Email;Phone1;AddressLine1;AddressLine2;City;State;PostalCode;");

                //Write the values
                file.WriteLine(string.Format("{0};{1};{2};{3};{4};{5};{6};{7};{8};{9}",
                    //Customer summary
                    customerData.CustomerID.Value,
                    customerData.CustomerName.Value,
                    //Customer class
                    customerData.CustomerClass.Value,
                    //Main contact
                    customerData.MainContact.Email.Value,
                    customerData.MainContact.Phone1.Value,
                    //Main address
                    customerData.MainContact.Address.AddressLine1.Value,
                    customerData.MainContact.Address.AddressLine2.Value,
                    customerData.MainContact.Address.City.Value,
                    customerData.MainContact.Address.State.Value,
                    customerData.MainContact.Address.PostalCode.Value));
            }
        }

        //Creating a customer record with custom fields
        public static void CreateCustomerWithCustomFields(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Creating a customer record with custom fields...");

            // Customer data
            string customerID = "TEDSMITH"; //Specify any customer ID, which does not exist in the system
            string customerName = "Ted Smith";
            string customerPersonalIDType = "Passport";
            string customerPersonalID = "12345678";

            //Specify the values of a new customer record
            Customer customerToBeCreated = new Customer
            {
                CustomerID = new StringValue { Value = customerID },
                CustomerName = new StringValue { Value = customerName },
                //Specify the values of the custom fields

                MainContact = new Contact
                {
                    CustomFields = new CustomField[]
                    {
                        new CustomStringField
                        {
                            fieldName = "UsrPersonalIDType", 
                            viewName = "DefContact",
                            Value = new StringValue { Value = customerPersonalIDType }
                        },
                        new CustomStringField
                        {
                            fieldName = "UsrPersonalID", 
                            viewName = "DefContact",
                            Value = new StringValue { Value = customerPersonalID }
                        },
                        new CustomBooleanField
                        {
                            fieldName = "UsrCreditRecordVerified", 
                            viewName = "DefContact",
                            Value = new BooleanValue { Value = true }
                        }        
                    }
                }
            };

            //Create a customer record with the specified values
            Customer newCustomer = (Customer)soapClient.Put(customerToBeCreated);

            //Display the ID of the created record and its custom string fields
            Console.WriteLine("Customer ID: " + newCustomer.CustomerID.Value);
            foreach (CustomField customField in newCustomer.MainContact.CustomFields)
            {
                var stringField = customField as CustomStringField;
                if (stringField != null)
                    Console.WriteLine(stringField.fieldName + ": " + stringField.Value.Value);
            }
            Console.WriteLine();
            Console.WriteLine("Press any key to continue");
            Console.ReadLine();
        }
    }
}
