﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MyStoreIntegration.MyStore;
using System.IO;

namespace MyStoreIntegration.Integration
{
    class CustomerPaymentMethodRegister
    {
        //Creating a credit card customer payment method  
        public static void CreateCustomerPaymentMethod(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Creating a credit card customer payment method...");

            //Customer payment method data
            string customerID = "C000000003";
            string paymentMethod = "VISA";
            string paymentProfileID = "35596199"; //Payment Profile ID value, which was obtained from Authorize.Net
            string cashAccount = "102050MYST";

            //Specify the parameters of the created customer payment method
            CustomerPaymentMethod paymMethToBeCreated = new CustomerPaymentMethod
            {
                CustomerID = new StringValue { Value = customerID },
                PaymentMethod = new StringValue { Value = paymentMethod },
                CashAccount = new StringValue { Value = cashAccount },
                Details = new[]
                        {
                            new CustomerPaymentMethodDetail
                            {
                                Description = new StringValue{Value = "Payment Profile ID"},
                                Value = new StringValue{Value = paymentProfileID}
                            }
                        }
            };

            //Create the customer payment method
            CustomerPaymentMethod createdMethod = (CustomerPaymentMethod)soapClient.Put(paymMethToBeCreated);

            //Display the card number of the created payment method
            Console.WriteLine("Card number: " + createdMethod.CardAccountNo.Value);
            Console.WriteLine();
            Console.WriteLine("Press any key to continue");
            Console.ReadLine();
        }

        //Retrieving the list of customer payment methods of a customer 
        public static void ExportCustomerPaymentMethods(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Getting the list of customer payment methods...");

            //Values for filtering
            string customerID = "C000000003";

            //Filter the customer payment methods by customer ID
            CustomerPaymentMethod paymMethToBeFound = new CustomerPaymentMethod
            {
                CustomerID = new StringSearch { Value = customerID },
            };

            //Get the list of customer payment methods
            Entity[] paymMethodList = soapClient.GetList(paymMethToBeFound);

            //Save results to a CSV file
            using (StreamWriter file = new StreamWriter(string.Format(@"CustomerPaymentMethods_{0}.csv", customerID)))
            {
                //Add headers to the file
                file.WriteLine("CustomerID;PaymentMethod;CardAccountNo;CashAccount;Active;");

                //Write the values for each customer payment method
                foreach (CustomerPaymentMethod pMethod in paymMethodList)
                {
                    file.WriteLine(string.Format("{0};{1};{2};{3};{4};",
                        pMethod.CustomerID.Value,
                        pMethod.PaymentMethod.Value,
                        pMethod.CardAccountNo.Value,
                        pMethod.CashAccount.Value,
                        pMethod.Active.Value));
                }
            }
        }
    }
}
