﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MyStoreIntegration.MyStore;
using System.IO;
using MyStoreIntegration.Helpers;

namespace MyStoreIntegration.Integration
{
    class InventoryManager
    {
        //Creating a stock item with attributes
        public static void CreateStockItem(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Creating a stock item with attributes...");

            //Stock item data
            string inventoryID = "BASESERV";
            string itemDescription = "Baseline level of performance";
            string itemClass = "STOCKITEM"; //Item class that has attributes defined
            string attributeName1 = "Operation System"; //An attribute of the item class (STOCKITEM)
            string attributeValue1 = "Windows";
            string attributeName2 = "Version Of Software"; //An attribute of the item class (STOCKITEM)
            string attributeValue2 = "Server 2012 R2";

            //Specify the values of the new stock item
            StockItem stockItemToBeCreated = new StockItem
            {
                InventoryID = new StringValue { Value = inventoryID },
                Description = new StringValue { Value = itemDescription },
                ItemClass = new StringValue { Value = itemClass },
                Attributes = new[]
                        {
                            new AttributeValue
                            {
                                AttributeID = new StringValue { Value = attributeName1 },
                                Value = new StringValue { Value = attributeValue1 }
                            },
                            new AttributeValue
                            {
                                AttributeID = new StringValue { Value = attributeName2 },
                                Value = new StringValue { Value = attributeValue2 }
                            }
                        }

            };

            //Create a stock item with the specified values
            StockItem newStockItem = (StockItem)soapClient.Put(stockItemToBeCreated);

            //Display the summary of the created stock item
            Console.WriteLine("Inventory ID: " + newStockItem.InventoryID.Value);
            foreach (AttributeValue attr in newStockItem.Attributes)
            {
                Console.WriteLine("Attribute name: " + attr.AttributeID.Value);
                Console.WriteLine("Attribute value: " + attr.Value.Value);
            }
            Console.WriteLine();
            Console.WriteLine("Press any key to continue");
            Console.ReadLine();
        }

        //Adding a note to a stock item record
        public static void AddNoteToStockItem(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Adding a note to a stock item record...");

            //Stock item data
            string inventoryID = "AALEGO500";
            string noteText = "Last updated on "; //In this example, you will append the date to this string in the code

            //Find the stock item in the system and specify the note text
            StockItem stockItemToBeUpdated = new StockItem
            {
                InventoryID = new StringSearch { Value = inventoryID },
                Note = noteText + DateTime.Now.ToShortDateString()
            };
            StockItem stockItem = (StockItem)soapClient.Put(stockItemToBeUpdated);

            //Display the summary of the created stock item
            Console.WriteLine("Inventory ID: " + stockItem.InventoryID.Value);
            Console.WriteLine("Note text: " + stockItem.Note);
            Console.WriteLine();
            Console.WriteLine("Press any key to continue");
            Console.ReadLine();
        }

        //Adding a file to a stock item record
        public static void AddFileToStockItem(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Adding a file to a stock item record...");

            //Input data
            string inventoryID = "AALEGO500";
            string filePath = "D:\\MyStoreIntegration\\SourceFiles\\"; //The path to
            //the file that you need to attach to the stock item
            string fileName = "T2MCRO.jpg"; //The name of the file

            //Find the needed stock item
            StockItem stockItemToBeFound = new StockItem
            {
                InventoryID = new StringSearch { Value = inventoryID },
            };
            StockItem stockItem = (StockItem)soapClient.Get(stockItemToBeFound);

            //Read the file data
            byte[] filedata;
            using (FileStream file =
            System.IO.File.Open(Path.Combine(filePath, fileName), FileMode.Open))
            {
                filedata = new byte[file.Length];
                file.Read(filedata, 0, filedata.Length);
            }

            //Add the file to the stock item record
            MyStore.File[] stockItemFiles = new[]
                    {
                        new MyStoreIntegration.MyStore.File
                        {
                            Name = fileName,
                            Content = filedata
                        }
                    };
            soapClient.PutFiles(stockItem, stockItemFiles);
        }

        //Adding a note to a warehouse detail line
        public static void AddNoteToWarehouseDetail(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Adding a note to a stock item warehouse detail line...");

            //Stock item data
            string inventoryID = "AALEGO500";
            string warehouse = "MAIN";
            string noteText = "Last updated on "; //In this example, you will append the date to this string in the code

            //Find the stock item in the system and specify the note text
            StockItem stockItemToBeUpdated = new StockItem
            {
                InventoryID = new StringSearch { Value = inventoryID },
            };
            StockItem stockItem = (StockItem)soapClient.Get(stockItemToBeUpdated);

            //Find the line to specify a note for
            StockItemWarehouseDetail warehouseDetail = stockItem.WarehouseDetails.Single(
                detailToBeFound => detailToBeFound.WarehouseID.Value == warehouse);
            warehouseDetail.Note = noteText + DateTime.Now.ToShortDateString();

            //Update the detail line
            stockItem = (StockItem)soapClient.Put(stockItem);
        }

    }
}
