﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MyStoreIntegration.MyStore;
using System.IO;
using MyStoreIntegration.Helpers;

namespace MyStoreIntegration.Integration
{
    class SOInvoiceProcessor
    {
        //Creating an invoice for a sales order
        public static void CreateSOInvoice(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Creating an invoice...");

            //Invoice data
            string invoiceType = "Invoice";
            string customerID = "C000000003";
            string firstOrderType = "SO";
            string firstOrderNbr = "000010"; //Sales order with the Completed status 
            //for the specified customer
            string firstShipmentNbr = "000006"; //Shipment with Confirmed status
            //that corresponds to firstOrderNbr sales order
            string secondOrderType = "SO";
            string secondOrderNbr = "000011"; //Sales order with the Completed 
            //status for the specified customer
            string secondShipmentNbr = "000007"; //Shipment with Confirmed status
            //that corresponds to secondOrderNbr sales order

            //Specify the values of a new invoice
            SalesInvoice soInvoice = new SalesInvoice
            {
                Type = new StringValue { Value = invoiceType },
                CustomerID = new StringValue { Value = customerID },
                Details = new[]
                        {
                            new SalesInvoiceDetail
                            {
                                ShipmentNbr = new StringValue { Value = firstShipmentNbr},
                                OrderType = new StringValue { Value = firstOrderType},
                                OrderNbr = new StringValue { Value = firstOrderNbr}
                            },
                            new SalesInvoiceDetail
                            {
                                ShipmentNbr = new StringValue { Value = secondShipmentNbr },
                                OrderType = new StringValue { Value = secondOrderType},
                                OrderNbr = new StringValue { Value = secondOrderNbr}
                            }
                        }
            };

            //Create an invoice with the specified values
            SalesInvoice newInvoice = (SalesInvoice)soapClient.Put(soInvoice);

            //Display the ID and customer class of the created record
            Console.WriteLine("Invoice type: " + newInvoice.Type.Value);
            Console.WriteLine("Invoice number: " + newInvoice.ReferenceNbr.Value);
            Console.WriteLine("Invoice status: " + newInvoice.Status.Value);
            Console.WriteLine();
            Console.WriteLine("Press any key to continue");
            Console.ReadLine();
        }

        //Releasing an invoice on the Invoices form (SO303000)
        public static void ReleaseSOInvoice(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Releasing an invoice...");

            //Invoice data
            string invoiceType = "Invoice";
            string invoiceNbr = "INV000045";

            //Find the invoice that should be released
            SalesInvoice soInvoice = new SalesInvoice
            {
                Type = new StringSearch { Value = invoiceType },
                ReferenceNbr = new StringSearch { Value = invoiceNbr },
                Hold = new BooleanValue { Value = false }
            };
            soInvoice = (SalesInvoice)soapClient.Put(soInvoice);

            //Release invoice
            InvokeResult invokeResult = soapClient.Invoke(soInvoice, new ReleaseSalesInvoice());

            //Monitor the status of the process
            ProcessResult processResult = LongRunProcessor.GetProcessResult(soapClient, invokeResult);

            //Get the confirmed shipment
            soInvoice = (SalesInvoice)soapClient.Get(new SalesInvoice { ID = processResult.EntityId });
            //Display the summary of the invoice
            Console.WriteLine("Invoice type: " + soInvoice.Type.Value);
            Console.WriteLine("Invoice number: " + soInvoice.ReferenceNbr.Value);
            Console.WriteLine("Invoice status: " + soInvoice.Status.Value);
            Console.WriteLine();
            Console.WriteLine("Press any key to continue");
            Console.ReadLine();
        }

        //Retrieving the list of invoices for the customer 
        public static void ExportInvoices(DefaultSoapClient soapClient)
        {
            Console.WriteLine("Retrieving the list of invoices of a customer...");

            //Input data
            string customerID = "C000000003";
            string docType = "Invoice";

            //Find the invoices of a customer
            SalesInvoice soInvoicesToBeFound = new SalesInvoice
            {
                ReturnBehavior = MyStore.ReturnBehavior.OnlySpecified,

                Type = new StringSearch { Value = docType },
                CustomerID = new StringSearch { Value = customerID },

                ReferenceNbr = new StringReturn(),
                Date = new DateTimeReturn(),
                Status = new StringReturn(),
            };
            Entity[] soInvoices = soapClient.GetList(soInvoicesToBeFound);

            //Save the results to a CSV file
            using (StreamWriter file = new StreamWriter(string.Format(@"SOInvoices_Customer_{0}.csv", customerID)))
            {
                //Add headers to the file
                file.WriteLine("Type;ReferenceNbr;Date;Status;");

                //Write the values for each invoice
                foreach (SalesInvoice soInvoice in soInvoices)
                {
                    file.WriteLine(string.Format("{0};{1};{2};{3};",
                        soInvoice.Type.Value,
                        soInvoice.ReferenceNbr.Value,
                        soInvoice.Date.Value,
                        soInvoice.Status.Value));
                }
            }
        }
    }
}
