﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MyStoreIntegration.MyStore;
using MyStoreIntegration.Integration;
using System.Net;
using System.Net.Security;
using System.Security.Cryptography.X509Certificates;

namespace MyStoreIntegration
{
    class Program
    {
        static void Main(string[] args)
        {
            //This code is necessary only if you connect to the website
            //through the HTTPS connection and
            //you need to use custom validation of an SSL certificate
            //(for example, if the website uses a self-signed certificate).
            ServicePointManager.ServerCertificateValidationCallback += new
            RemoteCertificateValidationCallback(ValidateRemoteCertificate);

            using (DefaultSoapClient soapClient = new DefaultSoapClient())
            {
                //Log in to Acumatica ERP
                soapClient.Login
                (
                    Properties.Settings.Default.UserName,
                    Properties.Settings.Default.Password,
                    Properties.Settings.Default.CompanyName,
                    Properties.Settings.Default.Branch,
                    null
                );

                try
                {
                    //Uncomment the method you want to execute
                    #region Integrated Customer Management
                    //Creating a customer record
                    //CustomerManager.CreateCustomer(soapClient);

                    //Updating a customer record
                    //CustomerManager.UpdateCustomer(soapClient);

                    //Adding a customer billing contact
                    //CustomerManager.AddCustomerBillingContact(soapClient);

                    //Retrieving customer data by customer ID
                    //CustomerManager.ExportCustomer(soapClient);

                    //Creating a customer record with custom fields
                    //CustomerManager.CreateCustomerWithCustomFields(soapClient);
                    #endregion

                    #region Inventory Data Retrieving
                    //Retrieving the list of stock items
                    //InventoryDataRetriever.ExportStockItems(soapClient);

                    //Retrieving the list of item sales categories
                    //InventoryDataRetriever.ExportSalesCategories(soapClient);

                    //Retrieving the list of stock items in a sales category
                    //InventoryDataRetriever.ExportStockItemsByCategory(soapClient);

                    //Retrieving the quantities of a stock item
                    //InventoryDataRetriever.ExportItemQty(soapClient);

                    //Retrieving the files that are attached to a stock item
                    //InventoryDataRetriever.ExportStockItemFiles(soapClient);

                    //Retrieving the price of a stock item
                    //InventoryDataRetriever.GetStockItemPrice(soapClient);
                    #endregion

                    #region Integrated Sales Order Processing
                    #region Sales Orders
                    //Creating a sales order
                    //SalesOrderProcessor.CreateSO(soapClient);

                    //Updating a sales order
                    //SalesOrderProcessor.UpdateSO(soapClient);

                    //Getting detail lines of a sales order
                    //SalesOrderProcessor.ExportSODetails(soapClient);

                    //Getting the list of sales orders of a customer
                    //SalesOrderProcessor.ExportSalesOrders(soapClient);
                    #endregion

                    #region Shipments
                    //Creating a shipment
                    //ShipmentProcessor.CreateShipment(soapClient);

                    //Confirming a shipment
                    //ShipmentProcessor.ConfirmShipment(soapClient);

                    //Getting the list of shipments of a customer
                    //ShipmentProcessor.ExportShipments(soapClient);
                    #endregion

                    #region Invoices
                    //Creating an invoice
                    //SOInvoiceProcessor.CreateSOInvoice(soapClient);

                    //Releasing an invoice
                    //SOInvoiceProcessor.ReleaseSOInvoice(soapClient);

                    //Retrieving the list of invoices of a customer
                    //SOInvoiceProcessor.ExportInvoices(soapClient);
                    #endregion

                    #region Customer Payment Methods
                    //Creating a credit card customer payment method
                    //CustomerPaymentMethodRegister.CreateCustomerPaymentMethod(soapClient);

                    //Getting the list of customer payment methods
                    //CustomerPaymentMethodRegister.ExportCustomerPaymentMethods(soapClient);
                    #endregion

                    #region Payments
                    //Creating a payment
                    //PaymentProcessor.CreatePayment(soapClient);

                    //Capturing a credit card payment
                    //PaymentProcessor.CapturePayment(soapClient);

                    //Releasing a payment
                    //PaymentProcessor.ReleasePayment(soapClient);

                    //Getting the list of payments of a customer
                    //PaymentProcessor.ExportPayments(soapClient);
                    #endregion
                    #endregion

                    #region Integrated Inventory Management
                    //Creating a stock item with attributes
                    //InventoryManager.CreateStockItem(soapClient);

                    //Adding a note to a stock item record
                    //InventoryManager.AddNoteToStockItem(soapClient);

                    //Adding a file to a stock item record
                    //InventoryManager.AddFileToStockItem(soapClient);

                    //Adding a note to a stock item warehouse detail line
                    //InventoryManager.AddNoteToWarehouseDetail(soapClient);

                    #endregion
                }
                catch (SystemException e)
                {
                    Console.WriteLine(e.Message);
                    Console.WriteLine();
                    Console.WriteLine("Press any key to continue");
                    Console.ReadLine();
                }
                finally
                {
                    //Log out from Acumatica ERP
                    soapClient.Logout();
                }
            }
        }

        //Callback, which is used to validate the certificate of
        //an Acumatica ERP website in an SSL conversation
        private static bool ValidateRemoteCertificate(object sender,
        X509Certificate cert, X509Chain chain, SslPolicyErrors policyErrors)
        {
            //For simplicity, this callback always returns true.
            //In a real integration application, you must check an SSL
            //certificate here.
            return true;
        }
    }
}
