﻿
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.IO;
using MyStoreRestIntegration.Helpers;

namespace MyStoreRestIntegration.Integration
{
    public class CustomerManager
    {
        //Creating a customer record
        public static void CreateCustomer(RestService rs)
        {
            Console.WriteLine("Creating a customer record...");

            // Customer data
            string customerID = "JOHNGOOD"; //Specify any customer ID that does not exist in the system
            string customerName = "John Good";
            string customerMainContactEmail = "demo@gmail.com";
            string customerMainContactAddressLine1 = "4030 Lake Washington Blvd NE";
            string customerMainContactAddressLine2 = "Suite 100";
            string customerMainContactCity = "Kirkland";
            string customerMainContactState = "WA";
            string customerMainContactPostalCode = "98033";

            //Convert the customer data to JSON format
            string entityAsString = JsonConvert.SerializeObject(new
            {
                CustomerID = new { value = customerID },
                CustomerName = new { value = customerName },
                MainContact = new
                {
                    Email = new { value = customerMainContactEmail },
                    Address = new
                    {
                        AddressLine1 = new { value = customerMainContactAddressLine1 },
                        AddressLine2 = new { value = customerMainContactAddressLine2 },
                        City = new { value = customerMainContactCity },
                        State = new { value = customerMainContactState },
                        PostalCode = new { value = customerMainContactPostalCode }
                    }
                }
            });

            //Create a customer record with the specified values
            string customerData = rs.Put("Customer", entityAsString, null);

            //Display the ID and customer class of the created record
            if (customerData != null)
            {
                customerID = JsonConvert.DeserializeObject<dynamic>(customerData)["CustomerID"].value;
                string customerClass = JsonConvert.DeserializeObject<dynamic>(customerData)["CustomerClass"].value;

                Console.WriteLine("Customer ID: " + customerID);
                Console.WriteLine("Customer class: " + customerClass);
                Console.WriteLine();
                Console.WriteLine("Press any key to continue");
                Console.ReadLine();
            }        
        }

        //Updating a customer record 
        public static void UpdateCustomer(RestService rs)
        {
            //Customer data
            string customerMainContactEmail = "info@jevy-comp.con"; //Specify email
                                                                    //address of a customer, which exists in the system

            string customerClass = "INTL"; //Specify one of the customer classes,
                                           //which are configured in the system
                                           //Specify the parameter

            //Filtering parameters and the entities to be expanded
            string parameters = @"$filter=MainContact/Email eq '" + customerMainContactEmail + "'&$expand=MainContact";

            //Convert the customer data to JSON format
            string entityAsString = JsonConvert.SerializeObject(new
            {
                CustomerClass = new { value = "INTL" }
            });

            //Update the customer data
            string customerUpdatedData = rs.Put("Customer", entityAsString, parameters);

            //Display the ID and customer class of the updated record
            if (customerUpdatedData != null)
            {
                string customerID = JsonConvert.DeserializeObject<dynamic>(customerUpdatedData)["CustomerID"].value;
                customerClass = JsonConvert.DeserializeObject<dynamic>(customerUpdatedData)["CustomerClass"].value;
                Console.WriteLine("Customer ID: " + customerID);
                Console.WriteLine("Customer class: " + customerClass);
                Console.WriteLine();
                Console.WriteLine("Press any key to continue");
                Console.ReadLine();
            }    
        }

        //Retrieving customer data by Customer ID
        public static void ExportCustomer(RestService rs)
        {
            //Customer data
            string customerID = "C000000003"; //Specify a customer ID,
            //which exists in the system  
          
            //The entities to be expanded in response
            string parameters = "$expand=MainContact";

            //Obtain the customer record with the specified customer ID
            string customerData = rs.GetByKeys("Customer", customerID, parameters);
            if (customerData != null)
            {
                JObject customerExported = JObject.Parse(customerData);

                //Save a customer record to a CSV file
                using (StreamWriter file = new StreamWriter(
                 string.Format(@"REST_Customer_{0}.csv", customerID)))
                {
                    //Add headers to the file
                    file.WriteLine("CustomerID;CustomerName;CustomerClass;Email;" +
                    "Phone1;AddressLine1;AddressLine2;City;State;PostalCode;");
                    // Write the values
                    file.WriteLine(
                    string.Format("{0};{1};{2};{3};{4};{5};{6};{7};{8};{9}",
                        //Customer summary    
                    customerExported.GetValue("CustomerID").Value<string>("value"),
                    customerExported.GetValue("CustomerName").Value<string>("value"),
                    customerExported.GetValue("CustomerClass").Value<string>("value"),
                    customerExported.GetValue("MainContact").Value<JToken>("Email").Value<string>("value"),
                    customerExported.GetValue("MainContact").Value<JToken>("Phone1").Value<string>("value"),
                        //Main address
                    JsonConvert.DeserializeObject<dynamic>(customerData)["MainContact"]["Address"]["AddressLine1"].value,
                    JsonConvert.DeserializeObject<dynamic>(customerData)["MainContact"]["Address"]["AddressLine2"].value,
                    JsonConvert.DeserializeObject<dynamic>(customerData)["MainContact"]["Address"]["City"].value,
                    JsonConvert.DeserializeObject<dynamic>(customerData)["MainContact"]["Address"]["State"].value,
                    JsonConvert.DeserializeObject<dynamic>(customerData)["MainContact"]["Address"]["PostalCode"].value));

                    file.Flush();
                }
            }        
        }

        //Adding a customer billing contact
        public static void AddCustomerBillingContact(RestService rs)
        {
            //Customer data
            string customerID = "C000000003"; //Specify a customer ID,
                                              //which exists in the system
            string contactTitle = "Mr.";
            string contactFirstName = "Jack";
            string contactLastName = "Green";
            string contactEmail = "green@jevy-comp.con";

            //Convert the customer data to JSON format
            string entityAsString = JsonConvert.SerializeObject(new
            {
                CustomerID = new { value = customerID },
                BillingContactSameAsMain = new { value = false },
                BillingContact = new
                {
                    Email = new { value = contactEmail },
                    Position = new
                    {
                        value = contactTitle + " " +
                            contactFirstName + " " + contactLastName
                    }
                }
            });

            //Update the customer data
            string customerData = rs.Put("Customer", entityAsString, null);

            //Display the customer ID and billing contact name and email address
            if (customerData != null)
            {
                string customerId = JsonConvert.DeserializeObject<dynamic>(customerData)["CustomerID"].value;
                string billingContactPosition = JsonConvert.DeserializeObject<dynamic>(customerData)["BillingContact"]["Position"].value;
                string billingContactEmail = JsonConvert.DeserializeObject<dynamic>(customerData)["BillingContact"]["Email"].value;
                
                Console.WriteLine("Customer ID: " + customerID);
                Console.WriteLine("Billing contact name: " + billingContactPosition);
                Console.WriteLine("Billing contact email: " + billingContactEmail);
                Console.WriteLine();
                Console.WriteLine("Press any key to continue");
                Console.ReadLine();
            }        
        }

        //Creating a customer record with custom fields
        public static void CreateCustomerWithCustomFields(RestService rs)
        {
            //Customer data
            string customerId = "TEDSMITH";
            string customerName = "Ted Smith";
            string customerPersonalIDType = "Passport";
            string customerPersonalID = "12345678";

            //Convert the customer data to JSON format
            string entityAsString = JsonConvert.SerializeObject(new
            {
                CustomerID = new { value = customerId },
                CustomerName = new { value = customerName },
                MainContact = new
                {
                    custom = new
                    {
                        DefContact = new
                        {
                            UsrPersonalIDType = new
                            {
                                type = "String",
                                value = customerPersonalIDType
                            },
                            UsrPersonalID = new
                            {
                                type = "String",
                                value = customerPersonalID
                            },
                            UsrCreditRecordVerified = new
                            {
                                type = "Boolean",
                                value = "true"
                            }
                        }
                    }
                }
            });

            //Create a customer record with the specified values
            string customerData = rs.Put("Customer", entityAsString, null);

            //Display the ID of the created record and its custom string fields
            if (customerData != null)
            {
                var customFields = JsonConvert.DeserializeObject<dynamic>(customerData)["MainContact"]["custom"].DefContact;
                
                Console.WriteLine("Customer ID: " + JsonConvert.DeserializeObject<dynamic>(customerData)["CustomerID"].value);
                foreach (JProperty customField in customFields)
                {
                    Console.WriteLine(customField.Name + ": " + customField.Value.SelectToken("value").ToString());
                }
                Console.WriteLine();
                Console.WriteLine("Press any key to continue");
                Console.ReadLine();
            }        

        }
    }
}
