﻿
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using MyStoreRestIntegration.Helpers;

namespace MyStoreRestIntegration.Integration
{
    public class CustomerPaymentMethodRegister
    {
        //Creating a credit card customer payment method
        public static void CreateCustomerPaymentMethod(RestService rs)
        {
            //Customer payment method data
            string customerID = "C000000003";
            string paymentMethod = "VISA";
            string paymentProfileID = "35596199"; //Payment Profile ID value, which is obtained from Authorize.Net
            string cashAccount = "102050MYST";

            //Convert the payment method data to JSON format
            string entityAsString = JsonConvert.SerializeObject(new
            {
                CustomerID = new { value = customerID },
                PaymentMethod = new { value = paymentMethod },
                CashAccount = new { value = cashAccount },
                Details = new[]
                {
                    new
                    {
                         Description = new  {value = "Payment Profile ID"},
                         Value = new  {value = paymentProfileID}
                    }       
                }               
            });

            //Create the customer payment method
            string methodCreated = rs.Put("CustomerPaymentMethod", entityAsString, null);

            if (methodCreated != null)
            {
                //Display the card number of the created payment method
                string card = JsonConvert.DeserializeObject<dynamic>(methodCreated)["CardAccountNo"].value;
                Console.WriteLine("Card number: " + card);
                Console.WriteLine();
                Console.WriteLine("Press any key to continue");
                Console.ReadLine();
            }    
        }

        //Retrieving the list of customer payment methods of a customer
        public static void ExportCustomerPaymentMethods(RestService rs)
        {
            //Customer data
            string customerID = "C000000003";

            //Filtering parameters
            string searchparameters = "$filter=CustomerID eq '" + customerID + "'";

            //Get the list of customer payment methods
            string paymentMethods = rs.Get("CustomerPaymentMethod", searchparameters);
            if (paymentMethods != null)
            {
                List<JObject> paymentMethodsList = JsonConvert.DeserializeObject<List<JObject>>(paymentMethods);

                //Save results to a CSV file
                using (StreamWriter file = new StreamWriter(string.Format(@"REST_CustomerPaymentMethods_{0}.csv", customerID)))
                {
                    //Add headers to the file
                    file.WriteLine(
                    "CustomerID;PaymentMethod;CardAccountNo;CashAccount;Active;");
                    //Write the values for each customer payment method
                    foreach (JObject paymentMethod in paymentMethodsList)
                    {
                        file.WriteLine(string.Format("{0};{1};{2};{3};{4};",
                        paymentMethod.GetValue("CustomerID").Value<string>("value"),
                        paymentMethod.GetValue("PaymentMethod").Value<string>("value"),
                        paymentMethod.GetValue("CardAccountNo").Value<string>("value"),
                        paymentMethod.GetValue("CashAccount").Value<string>("value"),
                        paymentMethod.GetValue("Active").Value<string>("value")));
                    }

                    file.Flush();
                }
            }        
        }      
    }
}
