﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MyStoreRestIntegration.Helpers;

namespace MyStoreRestIntegration.Integration
{
    public class InventoryManager
    {
        //Creating a stock item with attributes
        public static void CreateStockItem(RestService rs)
        {
            //Stock item data
            string inventoryID = "BASESERV";
            string itemDescription = "Baseline level of performance";
            string itemClass = "STOCKITEM"; //Item class that has attributes defined
            string attributeName1 = "Operation System"; //An attribute of the item class (STOCKITEM)
            string attributeValue1 = "Windows";
            string attributeName2 = "Version Of Software"; //An attribute of the item class (STOCKITEM)
            string attributeValue2 = "Server 2012 R2";

            //string parameters = "$expand=Attributes";

            //Convert the stock item data to JSON format
            string stockItemAsString = JsonConvert.SerializeObject(new
            {
                InventoryID = new { value = inventoryID },
                Description = new { value = itemDescription },
                ItemClass = new { value = itemClass },
                Attributes = new[]
                        {
                            new
                            {
                                AttributeID = new  {value = attributeName1},
                                Value = new  {value = attributeValue1}
                            },
                            new
                            {
                                AttributeID = new  {value = attributeName2},
                                Value = new  {value = attributeValue2}
                            }
                        }
            });

            //Create a stock item with the specified values
            string stockItemCreated = rs.Put("StockItem", stockItemAsString, null);
            if (stockItemCreated != null)
            {

                JObject stockItem = JObject.Parse(stockItemCreated);

                //Display the summary of the created stock item
                Console.WriteLine("Inventory ID: " + stockItem.GetValue("InventoryID").Value<string>("value"));

                JArray attributes = stockItem.Value<JArray>("Attributes");

                foreach (JObject attribute in attributes)
                {
                    Console.WriteLine("Attribute name: " + attribute.GetValue("AttributeID").Value<string>("value"));
                    Console.WriteLine("Attribute value: " + attribute.GetValue("Value").Value<string>("value"));
                }
                Console.WriteLine();
                Console.WriteLine("Press any key to continue");
                Console.ReadLine();
            }        
        }

        //Adding a note to a stock item record
        public static void AddNoteToStockItem(RestService rs)
        {
            //Stock item data
            string inventoryID = "AALEGO500";
            string noteText = "Last updated on " + DateTime.Now.ToShortDateString(); //In this example, you will append the date to this string in the code
            string noteTextAdded = "before test note";

            //Convert the stock item data to JSON format
            string stockItemAsString = JsonConvert.SerializeObject(new
            {
                InventoryID = new { value = inventoryID },
                note = noteText
            });

            //Update the stock item record
            string stockItemWithNote = rs.Put("StockItem", stockItemAsString, null);

            if (stockItemWithNote != null)
            {
                noteTextAdded = JsonConvert.DeserializeObject<dynamic>(stockItemWithNote)["note"];
                //Display the summary of the created stock item
                Console.WriteLine("Inventory ID: " + JsonConvert.DeserializeObject<dynamic>(stockItemWithNote)["InventoryID"].value);
                Console.WriteLine("Note text: " + noteTextAdded);
                Console.WriteLine();
                Console.WriteLine("Press any key to continue");
                Console.ReadLine();
            }        
        }

        //Adding a file to a stock item record
        public static void AddFileToStockItem(RestService rs)
        {
            //Input data
            string inventoryID = "AALEGO500";
            string filePath = "D:\\MyStoreIntegration\\SourceFiles\\"; //The path to
            //the file that you need to attach to the stock item
            string fileName = "T2MCRO.jpg"; //The name of the file

            //Read the file data and add the file to the stock item record
            byte[] filedata;
            using (FileStream file = File.Open(Path.Combine(filePath, fileName), FileMode.Open))
            {
                filedata = new byte[file.Length];
                file.Read(filedata, 0, filedata.Length);

                //Add the file
                Stream fileToAttach = new MemoryStream(filedata);
                rs.PutFile("StockItem", inventoryID, fileName, fileToAttach);
            }        
        }

        //Adding a note to a warehouse detail line
        public static void AddNoteToWarehouseDetail(RestService rs)
        {
            //Stock item data
            string inventoryID = "AALEGO500";
            string warehouse = "MAIN";
            string noteText = "Last updated on " + DateTime.Now.ToShortDateString(); //In this example, you will append the date to this string in the code
            //string parameters = "$expand=WarehouseDetails";

            //Convert the stock item data to JSON format
            string stockItemAsString = JsonConvert.SerializeObject(new
            {
                InventoryID = new { value = inventoryID },
                WarehouseDetails = new[]
                        {
                            new
                            {
                                WarehouseID = new {value = warehouse},
                                note = noteText
                            }
                        }

            });

            //Update the stock item record
            string stockItem = rs.Put("StockItem", stockItemAsString, null);

            //Display the note text
            if (stockItem != null)
            {
                string note = JsonConvert.DeserializeObject<dynamic>(stockItem)["WarehouseDetails"][0]["note"];
                Console.WriteLine("Note text: " + note);
                Console.WriteLine();
                Console.WriteLine("Press any key to continue");
                Console.ReadLine();
            }
        }
    }
}
