﻿
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MyStoreRestIntegration.Helpers;

namespace MyStoreRestIntegration.Integration
{
    public class SOInvoiceProcessor
    {
        //Creating an invoice
        public static void CreateSOInvoice(RestService rs)
        {
            //Invoice data
            string invoiceType = "Invoice";
            string customerID = "C000000003";
            string firstOrderType = "SO";
            string firstOrderNbr = "000010"; //Sales order of a customer with the value of customer ID equals to customerID with Completed status
            string firstShipmentNbr = "000006"; //Shipment with Confirmed status that corresponds to firstOrderNbr sales order
            string secondOrderType = "SO";
            string secondOrderNbr = "000011"; //Sales order of a customer with the value of customer ID equals to customerID with Completed status
            string secondShipmentNbr = "000007"; //Shipment with Confirmed status that corresponds to secondOrderNbr sales order

            //Convert the invoice data to JSON format
            string entityAsString = JsonConvert.SerializeObject(new
            {
                Type = new { value = invoiceType },
                CustomerID = new { value = customerID },
                Details = new[]
                        {
                            new
                            {
                                ShipmentNbr = new {value = firstShipmentNbr},
                                OrderType = new {value = firstOrderType},
                                OrderNbr = new  {value = firstOrderNbr}
                            },
                            new
                            {
                                ShipmentNbr = new  {value = secondShipmentNbr},
                                OrderType = new  {value = secondOrderType},
                                OrderNbr = new  {value = secondOrderNbr}
                            }
                        }
            });

            //Create the invoice
            string salesInvoiceCreated = rs.Put("SalesInvoice", entityAsString, null);

            if (salesInvoiceCreated != null)
            {
                JObject salesInvoice = JObject.Parse(salesInvoiceCreated);

                //Display the summary of the created record
                Console.WriteLine("Invoice type: " + salesInvoice.GetValue("Type").Value<string>("value"));
                Console.WriteLine("Invoice number: " + salesInvoice.GetValue("ReferenceNbr").Value<string>("value"));
                Console.WriteLine("Invoice status: " + salesInvoice.GetValue("Status").Value<string>("value"));
                Console.WriteLine();
                Console.WriteLine("Press any key to continue");
                Console.ReadLine();
            }        
        }

        //Releasing an invoice
        public static void ReleaseSOInvoice(RestService rs)
        {
            //Invoice data
            string invoiceType = "Invoice";
            string invoiceNbr = "INV000045";

            //Find the invoice that should be released
            string salesInvoiceToBeFound = rs.GetByKeys("SalesInvoice", invoiceType + '/' + invoiceNbr, null);

            if (salesInvoiceToBeFound != null)
            {
                //Clear the Hold checkbox
                string entityAsString = JsonConvert.SerializeObject(new
                {
                    Type = new { value = invoiceType },
                    ReferenceNbr = new { value = invoiceNbr },
                    Hold = new { value = false }
                });

                string salesInvoiceToBeReleased = rs.Put("SalesInvoice", entityAsString, null);

                if (salesInvoiceToBeReleased != null)
                {

                    entityAsString = JsonConvert.SerializeObject(new
                    {
                        entity = JObject.Parse(salesInvoiceToBeReleased)
                    });

                    //Release the invoice
                    string salesInvoiceReleased = rs.Post("SalesInvoice", "ReleaseSalesInvoice", entityAsString);

                    salesInvoiceReleased = rs.GetByKeys("SalesInvoice", invoiceType + '/' + invoiceNbr, null);
                    if (salesInvoiceReleased != null)
                    {
                        JObject salesInvoice = JObject.Parse(salesInvoiceReleased);

                        //Display the summary of the invoice                    
                        Console.WriteLine("Invoice type: " + salesInvoice.GetValue("Type").Value<string>("value"));
                        Console.WriteLine("Invoice number: " + salesInvoice.GetValue("ReferenceNbr").Value<string>("value"));
                        Console.WriteLine("Invoice status: " + salesInvoice.GetValue("Status").Value<string>("value"));
                        Console.WriteLine();
                        Console.WriteLine("Press any key to continue");
                        Console.ReadLine();
                    }
                }
            }        
        }

        //Retrieving the list of invoices of a customer
        public static void ExportInvoices(RestService rs)
        {
            //Input data
            string customerID = "C000000003";
            string docType = "Invoice";

            //Filtering parameters
            string searchParameters = "$filter=Type eq '" + docType + "'&$filter=CustomerID eq '" + customerID + "'";

            //Retrieve the list of invoices
            string invoicesExported = rs.Get("SalesInvoice", searchParameters);

            if (invoicesExported != null)
            {

                List<JObject> soInvoices = JsonConvert.DeserializeObject<List<JObject>>(invoicesExported);

                //Save results to a CSV file
                using (StreamWriter file = new StreamWriter(
                string.Format(@"REST_SOInvoices_Customer_{0}.csv", customerID)))
                {
                    //Add headers to the file
                    file.WriteLine("Type;ReferenceNbr;Date;Status;");
                    //Write the values for each invoice
                    foreach (JObject soInvoice in soInvoices)
                    {
                        file.WriteLine(string.Format("{0};{1};{2};{3};",
                        soInvoice.GetValue("Type").Value<string>("value"),
                        soInvoice.GetValue("ReferenceNbr").Value<string>("value"),
                        soInvoice.GetValue("Date").Value<string>("value"),
                        soInvoice.GetValue("Status").Value<string>("value")));
                    }

                    file.Flush();
                }
            }        
        }
    }
}
