﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MyStoreRestIntegration.Helpers;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;

using System.IO;

namespace MyStoreRestIntegration.Integration
{
    public class ShipmentProcessor
    {
        //Creating a shipment 
        public static void CreateShipment(RestService rs)
        {
            //Shipment data
            string shipmentType = "Shipment";
            string customerID = "C000000003";
            string warehouse = "MAIN";
            string firstOrderNbr = "000004"; //Sales order with the Open status
            //for the specified customer
            string firstOrderType = "SO";
            string secondOrderNbr = "000006"; //Sales order with the Open status
            //for the specified customer
            string secondOrderType = "SO";
            string parameters = "$expand=Details";

            //Find the first sales order to be shipped by OrderType and OrderNbr
            string orderForShipment1 = rs.GetByKeys("SalesOrder", firstOrderType + '/' + firstOrderNbr, parameters);
            string orderForShipment2 = rs.GetByKeys("SalesOrder", secondOrderType + '/' + secondOrderNbr, parameters);

            if (orderForShipment1 != null && orderForShipment2 != null)
            {

                //Select all stock items from the sales orders for shipment
                JArray stockItems1 = JObject.Parse(orderForShipment1).Value<JArray>("Details");

                List<Object> shipmentDetails = new List<Object>();

                foreach (JObject detail in stockItems1)
                {
                    shipmentDetails.Add(new
                    {
                        OrderType = new { value = firstOrderType },
                        OrderNbr = new { value = firstOrderNbr },
                        InventoryID = new { value = detail.GetValue("InventoryID").Value<string>("value") },
                        WarehouseID = new { value = detail.GetValue("WarehouseID").Value<string>("value") }
                    });
                }

                JArray stockItems2 = JObject.Parse(orderForShipment2).Value<JArray>("Details");

                foreach (JObject detail in stockItems2)
                {
                    shipmentDetails.Add(new
                    {
                        OrderType = new { value = secondOrderType },
                        OrderNbr = new { value = secondOrderNbr },
                        InventoryID = new { value = detail.GetValue("InventoryID").Value<string>("value") },
                        WarehouseID = new { value = detail.GetValue("WarehouseID").Value<string>("value") }
                    });
                }

                string entityAsString = JsonConvert.SerializeObject(new
                {
                    Type = new { value = shipmentType },
                    CustomerID = new { value = customerID },
                    WarehouseID = new { value = warehouse },
                    Details = shipmentDetails
                });

                //Create a shipment with the specified values
                string shipmentCreated = rs.Put("Shipment", entityAsString, null);

                if (shipmentCreated != null)
                {
                    JObject jShipmentCreated = JObject.Parse(shipmentCreated);

                    //Display the summary of the created record
                    Console.WriteLine("Shipment number: " + jShipmentCreated.GetValue("ShipmentNbr").Value<string>("value"));
                    Console.WriteLine("Shipment type: " + jShipmentCreated.GetValue("Type").Value<string>("value"));
                    Console.WriteLine("Shipment status: " + jShipmentCreated.GetValue("Status").Value<string>("value"));
                    Console.WriteLine();
                    Console.WriteLine("Press any key to continue");
                    Console.ReadLine();
                }
            }        
        }

        //Confirming a shipment
        public static void ConfirmShipment(RestService rs)
        {
            //Shipment data
            string shipmentNbr = "000001"; //A shipment that has On Hold status
            string shipmentType = "Shipment";

            //Convert the shipment data to JSON format
            string entityAsString = JsonConvert.SerializeObject(new
            {
                ShipmentNbr = new { value = shipmentNbr },
                Type = new { value = shipmentType },
                Hold = new { value = false }
            }
            );

            //Clear the Hold check box for the shipment
            string shipmentToBeConfirmed = rs.Put("Shipment", entityAsString, null);

            if (shipmentToBeConfirmed != null)
            {

                JObject shipment = JObject.Parse(shipmentToBeConfirmed);

                shipmentToBeConfirmed = JsonConvert.SerializeObject(new
                {
                    entity = new
                    {
                        ShipmentNbr = new { value = shipment.GetValue("ShipmentNbr").Value<string>("value") },
                        Type = new { value = shipment.GetValue("Type").Value<string>("value") }
                    }
                });

                //Confirm the shipment
                string shipmentConfirmed = rs.Post("Shipment", "ConfirmShipment", shipmentToBeConfirmed);

                //Retrieve the confirmed shipment
                shipmentConfirmed = rs.GetByKeys("Shipment", shipmentNbr, null);

                if (shipmentConfirmed != null)
                {

                    JObject jShipmentConfirmed = JObject.Parse(shipmentConfirmed);

                    //Display the summary of the shipment
                    Console.WriteLine("Shipment number: " + jShipmentConfirmed.GetValue("ShipmentNbr").Value<string>("value"));
                    Console.WriteLine("Shipment type: " + jShipmentConfirmed.GetValue("Type").Value<string>("value"));
                    Console.WriteLine("Shipment status: " + jShipmentConfirmed.GetValue("Status").Value<string>("value"));
                    Console.WriteLine();
                    Console.WriteLine("Press any key to continue");
                    Console.ReadLine();
                }
            }                  
        }

        //Exporting the list of shipments of a customer
        public static void ExportShipments(RestService rs)
        {
            //Shipment data
            string customerID = "C000000003";
            string shipmentType = "Shipment";
            string searchparameters = "$filter=CustomerID eq '" + customerID + "'&$filter=Type eq '" + shipmentType + "'";

            //Get the list of shipments
            string shipmentsExported = rs.Get("Shipment", searchparameters);
            if (shipmentsExported != null)
            {                
                List<JObject> shipmentsList = JsonConvert.DeserializeObject<List<JObject>>(shipmentsExported);

                //Save results to a CSV file
                using (StreamWriter file = new StreamWriter(
                string.Format(@"REST_Shipments_Customer_{0}.csv", customerID)))
                {
                    //Add headers to the file
                    file.WriteLine("Type;ShipmentNbr;CustomerID;Status;");
                    //Write the values of each shipment
                    foreach (JObject Shipment in shipmentsList)
                    {
                        file.WriteLine(string.Format("{0};{1};{2};{3};",
                        Shipment.GetValue("Type").Value<string>("value"),
                        Shipment.GetValue("ShipmentNbr").Value<string>("value"),
                        Shipment.GetValue("CustomerID").Value<string>("value"),
                        Shipment.GetValue("Status").Value<string>("value")));
                    }

                    file.Flush();
                }
            }
                    
        }
    }
}
