﻿using System;
using MyStoreRestIntegration.Integration;
using MyStoreRestIntegration.Helpers;
using System.Net;
using System.Net.Security;
using System.Security.Cryptography.X509Certificates;

namespace MyStoreRestIntegration
{
    class Program
    {
        static void Main(string[] args)
        {
            //This code is necessary only if you connect to the website
            //through the HTTPS connection and
            //you need to use custom validation of an SSL certificate
            //(for example, if the website uses a self-signed certificate).
            ServicePointManager.ServerCertificateValidationCallback += new
            RemoteCertificateValidationCallback(ValidateRemoteCertificate);

            using (RestService rs = new RestService())
            {
                //Log in to Acumatica ERP
                rs.Login();
                try
                {
                    //Uncomment the method you want to execute
                    #region Integrated Customer Management
                    //Creating a customer record
                    //CustomerManager.CreateCustomer(rs);

                    //Updating a customer record
                    //CustomerManager.UpdateCustomer(rs);

                    //Adding a customer billing contact
                    //CustomerManager.AddCustomerBillingContact(rs);

                    //Retrieving customer data by customer ID
                    //CustomerManager.ExportCustomer(rs);

                    //Creating a customer record with custom fields
                    //CustomerManager.CreateCustomerWithCustomFields(rs);
                    #endregion

                    #region Inventory Data Retrieving
                    //Retrieving the list of stock items
                    //InventoryDataRetriever.ExportStockItems(rs);

                    //Retrieving the list of item sales categories
                    //InventoryDataRetriever.ExportSalesCategories(rs);

                    //Retrieving the list of stock items in a sales category
                    //InventoryDataRetriever.ExportStockItemsByCategory(rs);

                    //Retrieving the quantities of a stock item
                    //InventoryDataRetriever.ExportItemQty(rs);

                    //Retrieving the files that are attached to a stock item
                    //InventoryDataRetriever.ExportStockItemFiles(rs);

                    //Retrieving the price of a stock item
                    //InventoryDataRetriever.GetStockItemPrice(rs);
                    #endregion

                    #region Integrated Sales Order Processing
                    #region Sales Orders
                    //Creating a sales order
                    //SalesOrderProcessor.CreateSO(rs);
                    
                    //Updating a sales order
                    //SalesOrderProcessor.UpdateSO(rs);

                    //Getting detail lines of a sales order
                    //SalesOrderProcessor.ExportSODetails(rs);

                    //Getting the list of sales orders of a customer
                    //SalesOrderProcessor.ExportSalesOrders(rs);
                    #endregion

                    #region Shipments
                    //Creating a shipment
                    //ShipmentProcessor.CreateShipment(rs);

                    //Confirming a shipment
                    //ShipmentProcessor.ConfirmShipment(rs);

                    //Getting the list of shipments of a customer
                    //ShipmentProcessor.ExportShipments(rs);
                    #endregion

                    #region Invoices
                    //Creating an invoice
                    //SOInvoiceProcessor.CreateSOInvoice(rs);

                    //Releasing an invoice
                    //SOInvoiceProcessor.ReleaseSOInvoice(rs);

                    //Retrieving the list of invoices of a customer
                    //SOInvoiceProcessor.ExportInvoices(rs);
                    #endregion

                    #region Customer Payment Methods
                    //Creating a credit card customer payment method
                    //CustomerPaymentMethodRegister.CreateCustomerPaymentMethod(rs);

                    //Getting the list of customer payment methods
                    //CustomerPaymentMethodRegister.ExportCustomerPaymentMethods(rs);
                    #endregion

                    #region Payments
                    //Creating a payment
                    //PaymentProcessor.CreatePayment(rs);

                    //Capturing a credit card payment
                    //PaymentProcessor.CapturePayment(rs);

                    //Releasing a payment
                    //PaymentProcessor.ReleasePayment(rs);

                    //Getting the list of payments of a customer
                    //PaymentProcessor.ExportPayments(rs);
                    #endregion
                    #endregion

                    #region Integrated Inventory Management
                    //Creating a stock item with attributes
                    //InventoryManager.CreateStockItem(rs);

                    //Adding a note to a stock item record
                    //InventoryManager.AddNoteToStockItem(rs);

                    //Adding a file to a stock item record
                    //InventoryManager.AddFileToStockItem(rs);

                    //Adding a note to a stock item warehouse detail line
                    //InventoryManager.AddNoteToWarehouseDetail(rs);
                    #endregion
                }
                catch (Exception e)
                {
                    Console.WriteLine(e);
                    Console.WriteLine();
                    Console.WriteLine("Press any key to continue");
                    Console.ReadLine();
                }
                finally
                {
                    //Log out from Acumatica ERP
                    rs.Logout();
                }
            }
        }

        //Callback, which is used to validate the certificate of
        //an Acumatica ERP website in an SSL conversation
        private static bool ValidateRemoteCertificate(object sender,
        X509Certificate cert, X509Chain chain, SslPolicyErrors policyErrors)
        {
            //For simplicity, this callback always returns true.
            //In a real integration application, you must check an SSL
            //certificate here.
            return true;
        }
    }
}